/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.item.JetpackItem;

public class SJTextUtil {
    private static final ITextComponent on = SJTextUtil.translate("misc", "enabled", TextFormatting.GREEN, new Object[0]);
    private static final ITextComponent off = SJTextUtil.translate("misc", "disabled", TextFormatting.RED, new Object[0]);
    private static final ITextComponent notAvailable = SJTextUtil.translate("misc", "notAvailable", TextFormatting.DARK_GRAY, new Object[0]);
    private static final String ENERGY_FORMAT = "%,d";

    public static ITextComponent translate(String prefix, String suffix, TextFormatting style, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslationTextComponent(key, params).func_240699_a_(style);
    }

    public static ITextComponent translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "simplyjetpacks", suffix);
        return new TranslationTextComponent(key, params);
    }

    public static ITextComponent energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energy", s1);
    }

    public static ITextComponent energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return SJTextUtil.translate("misc", "energyPerTick", TextFormatting.WHITE, new Object[]{s1});
    }

    public static ITextComponent energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return SJTextUtil.translate("misc", "energyWithMax", s1, s2);
    }

    public static ITextComponent fluidWithMax(IFluidHandler fluidHandler, int tank) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        return SJTextUtil.fluidWithMax(stack, fluidHandler.getTankCapacity(tank));
    }

    public static ITextComponent fluidWithMax(FluidStack stack, int tankCapacity) {
        ITextComponent fluidName = stack.getDisplayName();
        String s1 = String.format(ENERGY_FORMAT, stack.getAmount());
        String s2 = String.format(ENERGY_FORMAT, tankCapacity);
        return SJTextUtil.translate("misc", "fluidWithMax", fluidName, s1, s2);
    }

    public static ITextComponent getShiftText() {
        return SJTextUtil.translate("tooltip", "showDetails", new StringTextComponent("Shift").func_240699_a_(TextFormatting.GOLD));
    }

    public static void addBaseInfo(ItemStack stack, List<ITextComponent> list) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        list.add(SJTextUtil.translate("tooltip", "tier", jetpack.tier));
        if (jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "infiniteEnergy", TextFormatting.LIGHT_PURPLE, new Object[0]));
        } else {
            list.add(SJTextUtil.energyWithMax(jetpack.getEnergy(stack), jetpack.getCapacity(stack)));
        }
    }

    public static void addShiftInfo(ItemStack stack, List<ITextComponent> list) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.engine", TextFormatting.GOLD, new Object[]{jetpack.isEngineOn(stack) ? on : off}));
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.hover", TextFormatting.GOLD, new Object[]{jetpack.isHoverOn(stack) ? on : off}));
        if (jetpack.getJetpackType().getChargerMode()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.charger", TextFormatting.GOLD, new Object[]{jetpack.isChargerOn(stack) ? on : off}));
        }
        if (!jetpack.isCreative()) {
            list.add(SJTextUtil.translate("tooltip", "itemJetpack.energyUsage", TextFormatting.GOLD, new Object[]{SJTextUtil.energyPerTick(jetpack.getEnergyUsage(stack))}));
        }
        ITextComponent particle = SJTextUtil.translate("tooltip", "particle." + JetpackItem.getParticleId(stack), TextFormatting.WHITE, new Object[0]);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.particleType", TextFormatting.GOLD, new Object[]{particle}));
        IFormattableTextComponent throttle = new StringTextComponent(jetpack.getThrottle(stack) + "%").func_240699_a_(TextFormatting.WHITE);
        list.add(SJTextUtil.translate("tooltip", "itemJetpack.throttle", TextFormatting.GOLD, new Object[]{throttle}));
    }

    public static void addHUDInfoText(ItemStack stack, List<ITextComponent> list) {
        if (((Boolean)SimplyJetpacksConfig.showThrottle.get()).booleanValue()) {
            JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
            list.add(SJTextUtil.translate("hud", "throttle", jetpack.getThrottle(stack)));
        }
        list.add(SJTextUtil.getEnergyText(stack));
        list.add(SJTextUtil.getHUDStates(stack));
    }

    public static ITextComponent getEnergyText(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        if (jetpack.isCreative()) {
            return SJTextUtil.translate("hud", "energyDisplay", SJTextUtil.translate("hud", "infiniteEnergy", TextFormatting.LIGHT_PURPLE, new Object[0]));
        }
        int percent = (int)Math.ceil((double)jetpack.getEnergy(stack) / (double)jetpack.getCapacity(stack) * 100.0);
        ITextComponent percentageText = SJTextUtil.getColoredPercent(percent);
        ITextComponent exactText = SJTextUtil.energy(jetpack.getEnergy(stack));
        if (((Boolean)SimplyJetpacksConfig.showExactEnergy.get()).booleanValue()) {
            return SJTextUtil.translate("hud", "energyDisplayExtra", percentageText, exactText);
        }
        return SJTextUtil.translate("hud", "energyDisplay", percentageText);
    }

    public static ITextComponent getColoredPercent(int percent) {
        if (percent > 70) {
            return new StringTextComponent(String.format("%s%%", percent)).func_240699_a_(TextFormatting.GREEN);
        }
        if (percent > 40) {
            return new StringTextComponent(String.format("%s%%", percent)).func_240699_a_(TextFormatting.YELLOW);
        }
        if (percent > 10) {
            return new StringTextComponent(String.format("%s%%", percent)).func_240699_a_(TextFormatting.GOLD);
        }
        if (percent > 0) {
            return new StringTextComponent(String.format("%s%%", percent)).func_240699_a_(TextFormatting.RED);
        }
        return SJTextUtil.translate("hud", "energyDepleted", TextFormatting.RED, new Object[0]);
    }

    public static ITextComponent getHUDStates(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.func_77973_b();
        ArrayList<ITextComponent> statesTexts = new ArrayList<ITextComponent>();
        int stateCount = 1;
        TextFormatting on = TextFormatting.GREEN;
        TextFormatting off = TextFormatting.RED;
        TextFormatting notAvailable = TextFormatting.DARK_GRAY;
        ITextComponent engineState = SJTextUtil.translate("hud", "engine", jetpack.isEngineOn(stack) ? on : off, new Object[0]);
        ITextComponent hoverState = SJTextUtil.translate("hud", "hover", jetpack.isHoverOn(stack) ? on : off, new Object[0]);
        ITextComponent eHoverState = SJTextUtil.translate("hud", "eHover", jetpack.getJetpackType().getEmergencyHoverMode() ? (jetpack.isEHoverOn(stack) ? on : off) : notAvailable, new Object[0]);
        ITextComponent chargerState = SJTextUtil.translate("hud", "charger", jetpack.getJetpackType().getChargerMode() ? (jetpack.isChargerOn(stack) ? on : off) : notAvailable, new Object[0]);
        statesTexts.add(engineState);
        if (((Boolean)SimplyJetpacksConfig.showHoverState.get()).booleanValue() && jetpack.getJetpackType().getHoverMode()) {
            statesTexts.add(hoverState);
            ++stateCount;
        }
        if (((Boolean)SimplyJetpacksConfig.showEHoverState.get()).booleanValue() && jetpack.getJetpackType().getEmergencyHoverMode()) {
            statesTexts.add(eHoverState);
            ++stateCount;
        }
        if (((Boolean)SimplyJetpacksConfig.showChargerState.get()).booleanValue() && jetpack.getJetpackType().getChargerMode()) {
            statesTexts.add(chargerState);
            ++stateCount;
        }
        return SJTextUtil.translate("hud", "jetpackStates." + stateCount, statesTexts.toArray());
    }

    public static ITextComponent getStateToggle(String state, boolean value) {
        return SJTextUtil.translate("chat", "itemJetpack." + state, value ? on : off);
    }

    public static ITextComponent getEmergencyText() {
        return SJTextUtil.translate("chat", "itemJetpack.emergencyHoverModeActivated", TextFormatting.RED, new Object[0]);
    }
}

